
<?php $__env->startSection('navigation_content'); ?>
    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Header Navigation')); ?></h3>
            </div>
            <form action="<?php echo e(route('admin.navigation.position.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="header">
                <div class="site-card-body">
                    <p class="paragraph"><i icon-name="alert-triangle"></i><?php echo e(__('All the')); ?>

                        <strong><?php echo e(__('Menu Items are Draggable.')); ?></strong> <?php echo e(__('Once you drag then click')); ?>

                        <strong><?php echo e(__('Save Changes')); ?></strong></p>
                    <div class="site-table table-responsive mb-0">
                        <table class="table mb-0" id="sortable">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Menu Item')); ?></th>
                                <th scope="col"><?php echo e(__('Menu URL')); ?></th>
                                <th scope="col"><?php echo e(__('Page')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $navigations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navigation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <input type="hidden" name="<?php echo e($loop->index); ?>" value="<?php echo e($navigation->id); ?>">
                                    <td>
                                        <strong><?php echo e($navigation->name); ?></strong>
                                    </td>
                                    <td><?php echo e($navigation->url); ?></td>
                                    <td><strong
                                            class="site-badge primary"> <?php echo e($navigation?->page->title ?? 'Custom Url'); ?></strong>
                                    </td>
                                    <td>
                              <span type="button" data-bs-toggle="modal" data-bs-target="#removeMenuItem">
                                 <a href="<?php echo e(route('admin.navigation.menu.type.delete',[$navigation->id,'header'])); ?>"
                                    class="round-icon-btn red-btn" data-bs-toggle="tooltip" title=""
                                    data-bs-original-title="Remove Item">
                                          <i icon-name="x"></i>
                                </a>
                              </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="site-card-footer">
                    <button type="submit" class="site-btn-sm primary-btn"><?php echo e(__('Save Changes')); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            'use strict';
            $("#sortable tbody").sortable({
                cursor: "move",
                placeholder: "sortable-placeholder",
                helper: function (e, tr) {
                    var $originals = tr.children();
                    var $helper = tr.clone();
                    $helper.children().each(function (index) {
                        // Set helper cell sizes to match the original sizes
                        $(this).width($originals.eq(index).width());
                    });
                    return $helper;
                }
            }).disableSelection();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.navigation.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/navigation/header.blade.php ENDPATH**/ ?>