
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Rankings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('User Rankings')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ranking-create')): ?>
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#addNewRanking">
                                    <i icon-name="plus-circle"></i><?php echo e(__('Add New')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Ranking')); ?></th>
                                        <th scope="col"><?php echo e(__('Ranking Icon')); ?></th>
                                        <th scope="col"><?php echo e(__('Ranking Name')); ?></th>
                                        <th scope="col"><?php echo e(__('Minimum Earning')); ?></th>
                                        <th scope="col"><?php echo e(__('Bonus')); ?></th>
                                        <th scope="col"><?php echo e(__('Description')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ranking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e($ranking->ranking); ?></strong></td>
                                            <td>
                                                <img class="avatar" src="<?php echo e(asset($ranking->icon)); ?>" alt="">
                                            </td>
                                            <td>
                                                <strong><?php echo e($ranking->ranking_name); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($ranking->minimum_earnings.' '.$currency); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($ranking->bonus.' '.$currency); ?></strong>
                                            </td>
                                            <td><?php echo e($ranking->description); ?></td>
                                            <td>
                                                <?php if($ranking->status): ?>
                                                    <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge pending"><?php echo e(__('Disabled')); ?></div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ranking-edit')): ?>
                                                    <button class="round-icon-btn primary-btn editRanking" type="button"
                                                            data-ranking="<?php echo e(json_encode($ranking)); ?>">
                                                        <i icon-name="edit-3"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal for Add New Ranking -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ranking-create')): ?>
            <?php echo $__env->make('backend.ranking.include.__add_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New Ranking-->

        <!-- Modal for Edit Ranking -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ranking-edit')): ?>
            <?php echo $__env->make('backend.ranking.include.__edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit Ranking-->

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.editRanking').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var ranking = $(this).data('ranking');

            var url = '<?php echo e(route("admin.ranking.update", ":id")); ?>';
            url = url.replace(':id', ranking.id);
            $('#rankingEditForm').attr('action', url)
            $('.ranking').val(ranking.ranking);
            $('.ranking-name').val(ranking.ranking_name);
            $('.minimum-deposit').val(ranking.minimum_deposit);
            $('.minimum-invest').val(ranking.minimum_invest);
            $('.minimum-referral').val(ranking.minimum_referral);
            $('.minimum-referral-deposit').val(ranking.minimum_referral_deposit);
            $('.minimum-referral-invest').val(ranking.minimum_referral_invest);
            $('.minimum-earnings').val(ranking.minimum_earnings);
            $('.bonus').val(ranking.bonus);
            $('.description').val(ranking.description);
            imagePreviewAdd(ranking.icon);

            if (ranking.status) {
                $('#disableStatus').attr('checked', false);
                $('#activeStatus').attr('checked', true);
            } else {
                $('#activeStatus').attr('checked', false);
                $('#disableStatus').attr('checked', true);
            }

            $('#editRanking').modal('show');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/ranking/index.blade.php ENDPATH**/ ?>