
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Investments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <script src="<?php echo e(asset('global/js/jquery.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title"><?php echo e($title); ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="site-card">
                <div class="site-card-body">
                    <div class="site-table table-responsive">
                        <form action="<?php echo e(request()->url()); ?>" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                                <div class="filter d-flex">
                                    <select class="form-select form-select-sm me-2" name="filter_by_schema" aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Schema')); ?></option>
                                        <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($schema->id); ?>" <?php echo e(request('filter_by_schema') == $schema->id ? 'selected' : ''); ?>><?php echo e(__($schema->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <select class="form-select form-select-sm" name="status" aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Capital Back')); ?></option>
                                        <option value="1" <?php echo e(request('status') == '1' ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                        <option value="0" <?php echo e(request('status') == '0' ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo e(__('Icon')); ?></th>
                                <th><?php echo e(__('User')); ?></th>
                                <th><?php echo e(__('Schema')); ?></th>
                                <th><?php echo e(__('ROI')); ?></th>
                                <th><?php echo e(__('Profit')); ?></th>
                                <th><?php echo e(__('Capital Back')); ?></th>
                                <th><?php echo e(__('Period Remaining')); ?></th>
                                <th><?php echo e(__('Timeline')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_icon', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_schema', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_rio', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_profit', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_capital_back', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    <td>
                                        <?php if($item->return_type != 'period'): ?>
                                            Unlimited
                                        <?php else: ?>
                                            <?php echo e($item->number_of_period); ?> <?php echo e($item->number_of_period < 2 ? 'Time' : 'Times'); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $__env->make('backend.investment.include.__invest_next_profit_time', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($data->links('backend.include.__pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/investment/index.blade.php ENDPATH**/ ?>