
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add New KYC')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-8">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Add New KYC Form')); ?></h2>
                            <a href="<?php echo e(route('admin.kyc-form.index')); ?>" class="title-btn"><i
                                    icon-name="corner-down-left"></i><?php echo e(__('Back')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <div class="site-card">
                        <div class="site-card-body">
                            <form action="<?php echo e(route('admin.kyc-form.store')); ?>" method="post" class="row">
                                <?php echo csrf_field(); ?>

                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Name:')); ?></label>
                                        <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="box-input"
                                               placeholder="KYC Type Name" required/>
                                    </div>
                                </div>

                                <div class="col-xl-3">
                                    <a href="javascript:void(0)" id="generate"
                                       class="site-btn-xs primary-btn mb-3"><?php echo e(__('Add Field option')); ?></a>
                                </div>
                                <div class="addOptions">

                                </div>

                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
                                                <div class="switch-field">
                                                    <input
                                                        type="radio"
                                                        id="active-status"
                                                        name="status"
                                                        checked=""
                                                        value="1"
                                                    />
                                                    <label for="active-status"><?php echo e(__('Active')); ?></label>
                                                    <input
                                                        type="radio"
                                                        id="deactivate-status"
                                                        name="status"
                                                        value="0"
                                                    />
                                                    <label for="deactivate-status"><?php echo e(__('Deactivate')); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <button type="submit" class="site-btn primary-btn w-100">
                                        <?php echo e(__('Save Changes')); ?>

                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function (e) {
            var i = 0;
            "use strict";

            $("#generate").on('click', function () {
                ++i;
                var form = `<div class="mb-4">
                  <div class="option-remove-row row">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <input name="fields[` + i + `][name]" class="box-input" type="text" value="" required placeholder="Field Name">
                      </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="fields[` + i + `][type]" class="form-select form-select-lg mb-3">
                            <option value="text">Input Text</option>
                            <option value="textarea">Textarea</option>
                            <option value="file">File upload</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="fields[` + i + `][validation]" class="form-select form-select-lg mb-3">
                            <option value="required">Required</option>
                            <option value="nullable">Optional</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                      <button class="delete-option-row delete_desc" type="button">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                    </div>
                  </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.option-remove-row').parent().remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/kyc/create.blade.php ENDPATH**/ ?>