
<?php $__env->startSection('title'); ?>
    <?php echo e(__('KYC')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('KYC Forms')); ?></h2>
                            <a href="<?php echo e(route('admin.kyc-form.create')); ?>" class="title-btn"><i
                                    icon-name="plus-circle"></i><?php echo e(__('Add New')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Verification Name')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $kycs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($kyc->name); ?></strong>
                                            </td>
                                            <td>
                                                <?php if( $kyc->status): ?>
                                                    <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge pending"><?php echo e(__('Disabled')); ?></div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.kyc-form.edit',$kyc->id)); ?>"
                                                   class="round-icon-btn primary-btn">
                                                    <i icon-name="edit-3"></i>
                                                </a>
                                                <button type="button" data-id="<?php echo e($kyc->id); ?>"
                                                        data-name="<?php echo e($kyc->name); ?>"
                                                        class="round-icon-btn red-btn deleteKyc">
                                                    <i icon-name="trash-2"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Delete deleteKycType -->
        <div
            class="modal fade"
            id="deleteKyc"
            tabindex="-1"
            aria-labelledby="deleteKycTypeModalLabel"
            aria-hidden="true"
        >
            <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content site-table-modal">
                    <div class="modal-body popup-body">
                        <button
                            type="button"
                            class="btn-close"
                            data-bs-dismiss="modal"
                            aria-label="Close"
                        ></button>
                        <div class="popup-body-text centered">
                            <form method="post" id="kycEditForm">
                                <?php echo method_field('DELETE'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="info-icon">
                                    <i icon-name="alert-triangle"></i>
                                </div>
                                <div class="title">
                                    <h4><?php echo e(__('Are you sure?')); ?></h4>
                                </div>
                                <p>
                                    <?php echo e(__('You want to Delete')); ?> <strong
                                        class="name"></strong> <?php echo e(__('KYC Verification Type?')); ?>

                                </p>
                                <div class="action-btns">
                                    <button type="submit" class="site-btn-sm primary-btn me-2">
                                        <i icon-name="check"></i>
                                        <?php echo e(__(' Confirm')); ?>

                                    </button>
                                    <a href="" class="site-btn-sm red-btn" type="button"
                                       class="btn-close"
                                       data-bs-dismiss="modal"
                                       aria-label="Close">
                                        <i icon-name="x"></i>
                                        <?php echo e(__('Cancel')); ?>

                                    </a>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal for Delete deleteKycType-->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.deleteKyc').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            var name = $(this).data('name');

            var url = '<?php echo e(route("admin.kyc-form.destroy", ":id")); ?>';
            url = url.replace(':id', id);
            $('#kycEditForm').attr('action', url)

            $('.name').html(name);
            $('#deleteKyc').modal('show');
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/kyc/index.blade.php ENDPATH**/ ?>