
<?php $__env->startSection('title'); ?>
    <?php echo e($data->title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <?php echo e($data['meta_keywords']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <?php echo e($data['meta_description']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-content'); ?>

    <?php
        $blogs = \App\Models\Blog::where('locale',app()->getLocale())->latest()->paginate(6);
    ?>

    <section class="section-style-2 light-blue-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <div class="section-title centered">
                        <h2 data-aos="fade-down" data-aos-duration="1500"><?php echo e($data->title_big); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-4 col-sm-12">
                        <div class="single-blog" data-aos="fade-down" data-aos-duration="1000">
                            <div class="thumb">
                                <img src="<?php echo e(asset($blog->cover)); ?>" alt=""/>
                            </div>
                            <div class="content">
                                <div class="meta">
                                    <div class="date"><?php echo e($blog->created_at); ?></div>
                                </div>
                                <div class="title">
                                    <h3><a href="<?php echo e(route('blog-details',$blog->id)); ?>"><?php echo e($blog->title); ?></a></h3>
                                </div>
                                <div class="des">
                                    <?php echo Str::limit($blog->details,90); ?>

                                </div>
                                <div class="link">
                                    <a href="<?php echo e(route('blog-details',$blog->id)); ?>"><?php echo e(__('Continue Reading')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php echo e($blogs->links()); ?>


            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::pages.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/app/Providers/../../resources/views/frontend/default/pages/blog.blade.php ENDPATH**/ ?>