
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Transactions')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title"><?php echo e($title); ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="<?php echo e(request()->url()); ?>" method="get" id="filterForm">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>"
                                            placeholder="Search" />
                                    </div>
                                    <button type="button" class="apply-btn ms-2" id="search_button"><i
                                            data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                                <div class="filter d-flex">
                                    <div class="search w-100">
                                        <input class="me-2 w-100" id="date_range" type="text" name="daterange"
                                            value="<?php echo e(request('daterange') ? request('daterange') : null); ?>"
                                            placeholder="Date range" autocomplete="off" />
                                    </div>
                                    <select class="form-select form-select-sm me-2" name="filter_by_transaction_type"
                                        aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Transaction Type')); ?></option>
                                        <option value="investment"
                                            <?php echo e(request('investment') == 'investment' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Investment')); ?></option>
                                        <option value="withdraw" <?php echo e(request('withdraw') == 'withdraw' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Withdraw')); ?></option>
                                        <option value="deposit" <?php echo e(request('deposit') == 'deposit' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Deposit')); ?></option>
                                        <option value="signup_bonus"
                                            <?php echo e(request('signup_bonus') == 'signup_bonus' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Signup Bonus')); ?></option>
                                    </select>
                                    <select class="form-select form-select-sm" name="status"
                                        aria-label=".form-select-sm example">
                                        <option value="" selected><?php echo e(__('Filter By Status')); ?></option>
                                        <option value="success" <?php echo e(request('success') == 'success' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Success')); ?></option>
                                        <option value="pending" <?php echo e(request('pending') == 'pending' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Pending')); ?></option>
                                        <option value="failed" <?php echo e(request('failed') == 'failed' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Failed')); ?></option>
                                    </select>
                                    <input type="hidden" name="export" value="false" class="export_input">
                                    <button type="button" class="apply-btn export_button"><i
                                            data-lucide="download"></i><?php echo e(__('Export')); ?></button>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('User')); ?></th>
                                    <th><?php echo e(__('Transaction ID')); ?></th>
                                    <th><?php echo e(__('Type')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Gateway')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->created_at); ?></td>
                                        <td><?php echo $__env->make('backend.transaction.include.__user', [
                                            'user' => $item->user,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                        <td><?php echo e($item->tnx); ?></td>
                                        <td><?php echo $__env->make('backend.transaction.include.__txn_type', [
                                            'type' => $item->type,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                        <td><?php echo $__env->make('backend.transaction.include.__txn_amount', [
                                            'amount' => $item->final_amount,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                        <td><?php echo e($item->method); ?></td>
                                        <td><?php echo $__env->make('backend.transaction.include.__txn_status', [
                                            'status' => $item->status,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                                <?php endif; ?>
                            </tbody>
                            <!-- Modal for Send Email -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-mail-send')): ?>
                                <?php echo $__env->make('backend.user.include.__mail_send', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                            <!-- Modal for Send Email-->
                        </table>
                        <?php echo e($data->links('backend.include.__pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'DD/MM/YYYY',
                    applyLabel: 'Apply'
                }
            });

            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format(
                    'DD/MM/YYYY'));
                $('#range').val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format(
                    'DD/MM/YYYY'));
                $('.export_input').val('false');
                $('#filterForm').submit();
            });

            $('.export_button').on('click', function() {
                $('.export_input').val('true');
                $('#filterForm').submit();
            });

            $('#search_button').on('click', function() {
                $('.export_input').val('false');
                $('#filterForm').submit();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stapfcas/rah-fx.com/resources/views/backend/transaction/index.blade.php ENDPATH**/ ?>