@extends('frontend::pages.index')
@section('title')
{{ $data['title'] }}
@endsection
@section('meta_keywords')
{{ $data['meta_keywords'] }}
@endsection
@section('meta_description')
{{ $data['meta_description'] }}
@endsection
@section('page-content')

<div class="coinefy-contact-area section-space-top">
   <div class="container">
      <div class="row justify-content-center">
         <div class="col-xxl-6 col-xl-6 col-lg-8">
            <div class="section-heading section-title-space text-center">
               <span class="section-subtitle">{{ $data['title_small'] }}</span>
               <h2 class="section-title">{{ $data['title_big'] }}</h2>
            </div>
         </div>
      </div>
      <div class="row justify-content-center">
         <div class="col-xxl-8 col-xl-8">
            <div class="coinefy-contact-wrapper">
               <form action="{{ route('mail-send') }}" method="POST">
                  @csrf
                  <div class="row gy-24 gx-20">
                     <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
                        <div class="coinefy-single-input">
                           <label class="input-label" for="name">{{ __('Name') }}</label>
                           <div class="input-field">
                              <input type="text" id="name" name="name" class="box-input" placeholder="{{ __('Name') }}" required>
                           </div>
                        </div>
                     </div>
                     <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                        <div class="coinefy-single-input">
                           <label class="input-label" for="c-email">{{ __('Email') }}</label>
                           <div class="input-field">
                              <input type="text" id="c-email" name="email" class="box-input" placeholder="{{ __('Email') }}" required>
                           </div>
                        </div>
                     </div>
                     <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                        <div class="coinefy-single-input">
                           <label class="input-label" for="subject">{{ __('Subject') }}</label>
                           <div class="input-field">
                              <input type="text" id="subject" name="subject" class="box-input" placeholder="{{ __('Subject') }}" required>
                           </div>
                        </div>
                     </div>
                     <div class="col-xxl-12">
                        <div class="coinefy-single-input">
                           <div class="single-input">
                              <label class="input-label" for="message">{{ __('Message') }}</label>
                              <div class="input-field">
                                 <textarea name="msg" id="message" placeholder="{{ __('Message') }}" required></textarea>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="auth-from-btn-wrap">
                        <button class="site-btn primary-btn w-100" type="submit">{{ __('Send Your Message') }}</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>

   </div>
</div>
@include('frontend::home.include.__newsletter')
@endsection