@php
$investors = \App\Models\Invest::with('schema','user')->latest()->take(6)->get();
$withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
@endphp

<!-- Investors section start -->
<section class="investors-section p-relative z-index-11 section-space">
    <div class="container">
        <div class="row">
            <div class="col-xxl-5 col-xl-6 col-lg-6">
                <div class="section-heading section-title-space">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title">{{ $data['title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="row gy-30">
            <div class="col-xxl-6 col-xl-6">
                <div class="investors-table-wrapper">
                    <div class="table-card" data-background="{{asset('frontend/theme_base/coinefy/images/investors/withdraws-table.png')}}">
                        <h5 class="table-card-title">{{ __('Recent Investors') }}</h5>

                        <div class="investors-table table-responsive">
                            <table class="table">
                                <tbody>
                                    @foreach($investors as $investor)
                                    @php
                                    $calculateInterest = ($investor->interest * $investor->invest_amount) / 100;
                                    $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                                    @endphp
                                    <tr>
                                        <td>
                                            <h6 class="fs-12 white-text">{{ $investor->user->full_name }}</h6>
                                        </td>
                                        <td class="fs-10 white-text">{{ $investor->created_at }}</td>
                                        <td><span class="active-status">{{ $investor->user->status ? __('Active') : __('DeActive') }}</span></td>
                                        <td>
                                            <span class="w-img"><img src="{{asset('frontend/theme_base/coinefy/images/icons/stock-icon.png')}}" alt="stock-icon"></span>
                                        </td>
                                        <td><span class="fs-10 retro-lime-text">+{{ $investor->already_return_profit * $interest }} {{ $currency }}</span></td>
                                        <td>
                                            <span class="fs-14 fw-6 white-text">{{ $investor->invest_amount }} {{ $currency }}</span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="coin-one">
                        <img src="{{asset('frontend/theme_base/coinefy/images/investors/coin-01.png')}}" alt="coin">
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6">
                <div class="investors-table-wrapper style-two">
                    <div class="table-card" data-background="{{asset('frontend/theme_base/coinefy/images/investors/investors-table.png')}}">
                        <h5 class="table-card-title">{{ __('Recent Withdraws') }}</h5>
                        <div class="investors-table table-responsive">
                            <table class="table">
                                <tbody>
                                    @foreach($withdraws as $withdraw)
                                    <tr>
                                        <td>
                                            <h6 class="fs-12 white-text">{{ $withdraw->description }}</h6>
                                        </td>
                                        <td class="fs-10 white-text">{{ $withdraw->created_at }}</td>
                                        <td><span class="active-status warning">{{ ucfirst($withdraw->status->value) }}</span></td>
                                        <td><span class="fs-10 retro-lime-text">
                                        @if($withdraw->status == \App\Enums\TxnStatus::Success)
                                        -{{ $withdraw->final_amount }} {{ $currency }}
                                        @elseif($withdraw->status == \App\Enums\TxnStatus::Failed)
                                        +{{ $withdraw->final_amount }} {{ $currency }}
                                        @elseif($withdraw->status == \App\Enums\TxnStatus::Pending)
                                        {{ $withdraw->final_amount }} {{ $currency }}
                                        @endif
                                        </span></td>
                                        <td>
                                            <span class="fs-14 fw-6 white-text">{{ $withdraw->final_amount }} {{ $currency }}</span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="coin-two">
                        <img src="{{asset('frontend/theme_base/coinefy/images/investors/coin-02.png')}}" alt="coin">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Investors section end -->
</div>