@extends('frontend::pages.index')
@section('title')
{{ $data['title'] }}
@endsection
@section('meta_keywords')
{{ $data['meta_keywords'] }}
@endsection
@section('meta_description')
{{ $data['meta_description'] }}
@endsection
@section('page-content')
@php
$rankings = \App\Models\Ranking::where('status',true)->get()
@endphp

<!-- Ranking section start -->
<div class="rock-ranking-area inner-pages_space-top section_space-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-6 col-lg-8">
                <div class="section-title-wrapper text-center section_title_space">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title">{{ $data['title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="row gy-30">
            @foreach($rankings as $ranking)
            <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6">
                <div class="ranking-badge-item has_fade_anim" data-delay="0.15">
                    <div class="inner">
                        <div class="icon">
                            <div class="thumb">
                                <img src="{{ asset($ranking->icon) }}" alt="ranking-badge">
                            </div>
                            <div class="contents">
                                <h3 class="title">{{ $ranking->ranking_name }}</h3>
                                <p class="description">{{ $ranking->description }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
<!-- Ranking section end -->

<!-- CTA section end -->
<?php
$landata = \App\Models\LandingPage::where('code', 'cta')
    ->where('locale', app()->getLocale())
    ->first();

$data = json_decode($landata['data'], true);
?>
@include('frontend::home.include.__cta',$data)
<!-- Cta section end -->

@include('frontend::home.include.__newsletter')
@endsection