<div class="pagination-wrapper d-flex justify-content-center mt-50">
    <div class="td-pagination">
        @if ($paginator->hasPages())
            <nav>
                <ul>
                    <!-- Previous Page Link -->
                    @if ($paginator->onFirstPage())
                        <li><span><i class="fa-regular fa-chevron-left"></i></span></li>
                    @else
                        <li><a href="{{ $paginator->previousPageUrl() }}" rel="prev"><i class="fa-regular fa-chevron-left"></i></a></li>
                    @endif

                <!-- Pagination Elements -->
                    @foreach ($elements as $element)
                        @if (is_string($element))
                            <li><span>{{ $element }}</span></li>
                        @endif
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <li><a class="current" href="#">{{ $page }}</a></li>
                                @else
                                    <li><a href="{{ $url }}">{{ $page }}</a></li>
                                @endif
                            @endforeach
                        @endif
                    @endforeach

                <!-- Next Page Link -->
                    @if ($paginator->hasMorePages())
                        <li><a href="{{ $paginator->nextPageUrl() }}" rel="next"><i class="fa-regular fa-chevron-right"></i></a></li>
                    @else
                        <li><span><i class="fa-regular fa-chevron-right"></i></span></li>
                    @endif
                </ul>
            </nav>
        @endif
    </div>
</div>
