@php
$landingContent =\App\Models\LandingContent::where('type','whychooseus')->where('locale',app()->getLocale())->get();
@endphp

<!-- Why Choose us section start -->
<section class="td-why-choose-us-section include-bg fix" data-background="{{ asset('frontend/theme_base/coin_orbit/images/bg/why-choose-pattern.png') }}">
    <div class="container">
        <div class="row">
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-12">
                <div class="section-title-wrapper has_fade_anim">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title">{{ $data['title_big'] }}</h2>
                </div>
            </div>
            @foreach($landingContent as $content)
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="why-choose-item has_fade_anim">
                    <div class="icon">
                              <span>
                                   @if(content_exists($content->icon))
                                 <img src="{{ asset($content->icon) }}" alt="why-choose Icon">
                                  @else
                                      <i class="{{ $content->icon }}"></i>
                                  @endif
                              </span>
                    </div>
                    <div class="contents">
                        <h5 class="title">{{ $content->title }}</h5>
                        <p class="description">{{ $content->description }}</p>
                    </div>
                </div>
            </div>
            @endforeach
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="why-choose-thumb has_fade_anim">
                    <img src="{{ asset('frontend/theme_base/coin_orbit/images/why-choose/why-choose-thumb.png') }}" alt="Why Choose">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Why Choose us section end -->