<div class="tab-pane fade {{ request()->get('tab') === 'transactions' ? 'show active' : '' }}" id="pills-transactions" role="tabpanel" aria-labelledby="pills-transactions-tab">
    <div class="site-card">
        <div class="site-card-header">
            <h3 class="title">{{ __('Transactions') }}</h3>
        </div>
        <div class="site-card-body table-responsive">
            <form action="{{ request()->url() }}" method="get">
                <div class="site-datatable">
                    <table id="dataTable" class="display data-table">
                        <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Transaction ID') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Gateway') }}</th>
                            <th>{{ __('Status') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($data as $item)
                            <tr>
                                <td>{{ $item->created_at }}</td>
                                <td>@include('backend.transaction.include.__user', ['user' => $item->user])</td>
                                <td>{{ $item->tnx }}</td>
                                <td>@include('backend.transaction.include.__txn_type', ['type' => $item->type])</td>
                                <td>@include('backend.transaction.include.__txn_amount', ['amount' => $item->final_amount])</td>
                                <td>{{ $item->method }}</td>
                                <td>@include('backend.transaction.include.__txn_status', ['status' => $item->status])</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    @if ($data->isEmpty())
                        <p>{{ __('No Transaction found.') }}</p>
                    @endif
                    {{ $data->links('backend.include.__pagination') }}
                </div>
            </form>
        </div>
    </div>
</div>