<div class="tab-pane  {{ request()->get('tab') === 'informations' ? 'show active' : '' }} " id="pills-informations"
    role="tabpanel" aria-labelledby="pills-informations-tab">
    @can('customer-basic-manage')
        <div class="row">
            <div class="col-xl-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Basic Info') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <form action="{{ route('admin.user.update', $user->id) }}" method="post" enctype="multipart/form-data">
                            @method('PUT')
                            @csrf
                            <div class="row">
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('First Name:') }}</label>
                                        <input type="text" class="box-input" value="{{ $user->first_name }}"
                                            name="first_name" required="">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Last Name:') }}</label>
                                        <input type="text" class="box-input" value="{{ $user->last_name }}"
                                            required="" name="last_name">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Country:') }}</label>
                                        <input type="text" class="box-input" value="{{ $user->country }}" disabled>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Phone:') }}</label>
                                        <input type="text" class="box-input" value="{{ safe($user->phone) }}" disabled>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Username:') }}</label>
                                        <input type="text" class="box-input" name="username"
                                            value="{{ safe($user->username) }}" required="">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Email:') }}</label>
                                        <input type="email" class="box-input" value="{{ safe($user->email) }}" disabled>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Gender:') }}</label>
                                        <input type="text" class="box-input" value="{{ $user->gender }}" required=""
                                            disabled>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Date of Birth:') }}</label>
                                        <input type="text" class="box-input" value="{{ $user->date_of_birth }}"
                                            disabled>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('City:') }}</label>
                                        <input type="text" name="city" class="box-input" value="{{ $user->city }}">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Zip Code:') }}</label>
                                        <input type="text" class="box-input" name="zip_code"
                                            value="{{ $user->zip_code }}">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Address:') }}</label>
                                        <input type="text" class="box-input" name="address"
                                            value="{{ $user->address }}">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('Joining Date:') }}</label>
                                        <input type="text" class="box-input"
                                            value="{{ carbonInstance($user->created_at)->toDayDateTimeString() }}"
                                            required="" disabled>
                                    </div>
                                </div>

                                @php
                                    $registerCustomFields = json_decode(getPageSetting('register_custom_fields'), true);
                                    $user->custom_fields_data = is_null($user->custom_fields_data)
                                        ? []
                                        : $user->custom_fields_data;
                                @endphp

                                @if ($registerCustomFields)
                                    @foreach ($registerCustomFields as $key => $field)
                                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label"
                                                    for="">{{ $field['name'] }}</label>
                                                @if ($field['type'] == 'textarea')
                                                    <textarea name="custom_fields_data[{{ $field['name'] }}]" class="form-textarea">{{ $user->custom_fields_data[$field['name']] ?? '' }}</textarea>
                                                @elseif(in_array($field['type'], ['file', 'camera']))
                                                    @php
                                                        $filePath = $user->custom_fields_data[$field['name']] ?? '';
                                                        $oldFile = file_exists('assets/' . $filePath);
                                                    @endphp
                                                    <div class="wrap-custom-file">
                                                        <input type="file"
                                                            name="custom_fields_data[{{ $field['name'] }}]"
                                                            id="{{ $key }}" accept=".gif, .jpg, .png" />
                                                        <label for="{{ $key }}"
                                                            @if ($oldFile) class="file-ok" style="background-image: url({{ asset($filePath) }})" @endif>
                                                            <img class="upload-icon"
                                                                src="{{ asset('front/images/icons/upload.svg') }}"
                                                                alt="" />
                                                            <span>{{ $field['name'] }}</span>
                                                        </label>
                                                    </div>
                                                @else
                                                    <input type="text" name="custom_fields_data[{{ $field['name'] }}]"
                                                        class="box-input"
                                                        value="{{ $user->custom_fields_data[$field['name']] ?? '' }}" />
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                @endif

                                <div class="col-xl-12">
                                    <button type="submit"
                                        class="site-btn-sm primary-btn w-100 centered">{{ __('Save Changes') }}</button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endcan
    @can('customer-change-password')
        <div class="row">
            <div class="col-xl-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Change Password') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <form action="{{ route('admin.user.password-update', $user->id) }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label">{{ __('New Password:') }}</label>
                                        <input type="password" name="new_password" class="box-input" required="">
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                    <div class="site-input-groups">
                                        <label for=""
                                            class="box-input-label">{{ __('Confirm Password:') }}</label>
                                        <input type="password" name="new_confirm_password" class="box-input"
                                            required="">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <button type="submit"
                                        class="site-btn-sm primary-btn w-100 centered">{{ __('Change Password') }}</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    @endcan

</div>
