@extends('backend.layouts.app')
@section('title')
    {{ __('Transactions') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title">{{ $title }}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get" id="filterForm">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}"
                                            placeholder="Search" />
                                    </div>
                                    <button type="button" class="apply-btn ms-2" id="search_button"><i
                                            data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                                <div class="filter d-flex">
                                    <div class="search w-100">
                                        <input class="me-2 w-100" id="date_range" type="text" name="daterange"
                                            value="{{ request('daterange') ? request('daterange') : null }}"
                                            placeholder="Date range" autocomplete="off" />
                                    </div>
                                    <select class="form-select form-select-sm me-2" name="filter_by_transaction_type"
                                        aria-label=".form-select-sm example">
                                        <option value="" selected>{{ __('Filter By Transaction Type') }}</option>
                                        <option value="investment"
                                            {{ request('investment') == 'investment' ? 'selected' : '' }}>
                                            {{ __('Investment') }}</option>
                                        <option value="withdraw" {{ request('withdraw') == 'withdraw' ? 'selected' : '' }}>
                                            {{ __('Withdraw') }}</option>
                                        <option value="deposit" {{ request('deposit') == 'deposit' ? 'selected' : '' }}>
                                            {{ __('Deposit') }}</option>
                                        <option value="signup_bonus"
                                            {{ request('signup_bonus') == 'signup_bonus' ? 'selected' : '' }}>
                                            {{ __('Signup Bonus') }}</option>
                                    </select>
                                    <select class="form-select form-select-sm" name="status"
                                        aria-label=".form-select-sm example">
                                        <option value="" selected>{{ __('Filter By Status') }}</option>
                                        <option value="success" {{ request('success') == 'success' ? 'selected' : '' }}>
                                            {{ __('Success') }}</option>
                                        <option value="pending" {{ request('pending') == 'pending' ? 'selected' : '' }}>
                                            {{ __('Pending') }}</option>
                                        <option value="failed" {{ request('failed') == 'failed' ? 'selected' : '' }}>
                                            {{ __('Failed') }}</option>
                                    </select>
                                    <input type="hidden" name="export" value="false" class="export_input">
                                    <button type="button" class="apply-btn export_button"><i
                                            data-lucide="download"></i>{{ __('Export') }}</button>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('User') }}</th>
                                    <th>{{ __('Transaction ID') }}</th>
                                    <th>{{ __('Type') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                    <th>{{ __('Gateway') }}</th>
                                    <th>{{ __('Status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- @dd($data); --}}
                                @forelse($data as $item)
                                    <tr>
                                        <td>{{ $item->created_at }}</td>
                                        <td>@include('backend.transaction.include.__user', [
                                            'user' => $item->user,
                                        ])</td>
                                        <td>{{ $item->tnx }}</td>
                                        <td>@include('backend.transaction.include.__txn_type', [
                                            'type' => $item->type,
                                        ])</td>
                                        <td>@include('backend.transaction.include.__txn_amount', [
                                            'amount' => $item->final_amount,
                                        ])</td>
                                        <td>{{ $item->method }}</td>
                                        <td>@include('backend.transaction.include.__txn_status', [
                                            'status' => $item->status,
                                        ])</td>
                                    </tr>
                                @empty
                                    <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                                @endforelse
                            </tbody>
                            <!-- Modal for Send Email -->
                            @can('customer-mail-send')
                                @include('backend.user.include.__mail_send')
                            @endcan
                            <!-- Modal for Send Email-->
                        </table>
                        {{ $data->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'DD/MM/YYYY',
                    applyLabel: 'Apply'
                }
            });

            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format(
                    'DD/MM/YYYY'));
                $('#range').val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format(
                    'DD/MM/YYYY'));
                $('.export_input').val('false');
                $('#filterForm').submit();
            });

            $('.export_button').on('click', function() {
                $('.export_input').val('true');
                $('#filterForm').submit();
            });

            $('#search_button').on('click', function() {
                $('.export_input').val('false');
                $('#filterForm').submit();
            });
        });
    </script>
@endsection
