@extends('backend.deposit.index')
@section('title')
    {{ __('Pending Manual Deposit') }}
@endsection
@section('deposit_content')
    <div class="col-xl-12 col-md-12">
        <div class="site-card">
            <div class="site-card-body table-responsive">
                <div class="site-table table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Transaction ID') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Charge') }}</th>
                            <th>{{ __('Gateway') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Action') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($pendings as $pending)

                            <tr>
                                <td>{{ $pending->created_at }}</td>
                                <td>@include('backend.transaction.include.__user', ['item' => $pending])</td>
                                <td>{{ $pending->tnx}}</td>
                                <td>@include('backend.transaction.include.__txn_amount', ['item' => $pending])</td>
                                <td>{{ $pending->charge . ' ' . setting('site_currency', 'global') }}</td>
                                <td>{{$pending->method}}</td>
                                <td>@include('backend.transaction.include.__txn_status', ['status' => $pending->status])</td>
                                <td>@include('backend.deposit.include.__action', ['id' => $pending->id])</td>
                            </tr>
                        @empty
                            <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                        @endforelse
                        </tbody>
                    </table>

                    {{ $pendings->links('backend.include.__pagination') }}
                </div>
            </div>
        </div>
        <!-- Modal for Pending Deposit Approval -->
        @can('deposit-action')
            <div
                    class="modal fade"
                    id="deposit-action-modal"
                    tabindex="-1"
                    aria-labelledby="editPendingDepositModalLabel"
                    aria-hidden="true"
            >
                <div class="modal-dialog modal-md modal-dialog-centered">
                    <div class="modal-content site-table-modal">
                        <div class="modal-body popup-body">
                            <button
                                    type="button"
                                    class="btn-close"
                                    data-bs-dismiss="modal"
                                    aria-label="Close"
                            ></button>
                            <div class="popup-body-text deposit-action">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
    @endcan

    <!-- Modal for Pending Deposit Approval -->
    </div>
@endsection
@section('script')
    <script>
        (function ($) {
            "use strict";

            let loader = '<div class="text-center"><img src="{{ asset('front/images/loader.gif') }}" width="100"><h5>{{ __('Please wait') }}...</h5></div>';

            //send mail modal form open
            $('body').on('click', '#deposit-action', function () {
                $('.deposit-action').html(loader);

                var id = $(this).data('id');
                var url = '{{ route("admin.deposit.action",":id") }}';
                url = url.replace(':id', id);
                $.get(url, function (data) {
                    $('.deposit-action').html(data)
                    imagePreview()
                });

                $('#deposit-action-modal').modal('toggle');
            })


        })(jQuery);
    </script>
@endsection
