<?php

namespace Payment\AuthorizeDotNet;

use Illuminate\Support\Facades\Crypt;
use net\authorize\api\constants\ANetEnvironment;
use net\authorize\api\contract\v1\GetHostedPaymentPageRequest;
use net\authorize\api\contract\v1\MerchantAuthenticationType;
use net\authorize\api\contract\v1\SettingType;
use net\authorize\api\contract\v1\TransactionRequestType;
use net\authorize\api\controller\GetHostedPaymentPageController;
use Payment\Transaction\BaseTxn;

class AuthorizeDotNetTxn extends BaseTxn
{
    private $loginId;

    private $transactionKey;

    /**
     * @var mixed|string
     */
    public function __construct($txnInfo)
    {
        parent::__construct($txnInfo);
        $gatewayInfo = gateway_info('authorize.net');
        $this->loginId = $gatewayInfo->login_id;
        $this->transactionKey = $gatewayInfo->transaction_key;
    }

    public function deposit()
    {
        $merchantAuthentication = new MerchantAuthenticationType;
        $merchantAuthentication->setName($this->loginId);
        $merchantAuthentication->setTransactionKey($this->transactionKey);

        $refId = $this->txn;

        $transactionRequestType = new TransactionRequestType;
        $transactionRequestType->setTransactionType('authCaptureTransaction');
        $transactionRequestType->setAmount($this->amount);

        $setting1 = new SettingType;
        $setting1->setSettingName('hostedPaymentButtonOptions');
        $setting1->setSettingValue(json_encode([
            'text' => 'Pay',
        ]));

        $setting2 = new SettingType;
        $setting2->setSettingName('hostedPaymentOrderOptions');
        $setting2->setSettingValue(json_encode([
            'show' => false,
        ]));

        $setting3 = new SettingType;
        $setting3->setSettingName('hostedPaymentReturnOptions');
        $setting3->setSettingValue(json_encode([
            'url' => route('status.success', ['reftrn' => Crypt::encryptString($this->txn)]),
            'cancelUrl' => route('status.cancel'),
            'showReceipt' => false,
        ]));

        $request = new GetHostedPaymentPageRequest;
        $request->setMerchantAuthentication($merchantAuthentication);
        $request->setRefId($refId);
        $request->setTransactionRequest($transactionRequestType);

        $request->addToHostedPaymentSettings($setting1);
        $request->addToHostedPaymentSettings($setting2);
        $request->addToHostedPaymentSettings($setting3);

        $controller = new GetHostedPaymentPageController($request);
        $response = $controller->executeWithApiResponse(ANetEnvironment::PRODUCTION);
        if (($response != null) && ($response->getMessages()->getResultCode() == 'Ok')) {
            $token = $response->getToken();

            return view('frontend::deposit.payment_process', compact('token'));
        }
        echo "ERROR :  Failed to get hosted payment page token\n";
        $errorMessages = $response->getMessages()->getMessage();
        echo 'RESPONSE : '.$errorMessages[0]->getCode().'  '.$errorMessages[0]->getText()."\n";

    }
}
