/*----------------------------------------*/
/* Coinefy main jQuery
/*----------------------------------------*/

(function ($) {
  'use strict';

  // Preloder activation
  $(window).on('load', function (event) {
    $('#preloader').delay(500).fadeOut(500);
  });

  // Mobile menu
  if ($("#mobile-menu").length > 0) {
    $("#mobile-menu").meanmenu({
      meanMenuContainer: ".mobile-menu",
      meanScreenWidth: "991",
      meanExpand: ['<i class="fa-regular fa-angle-right"></i>'],
    });
  }

  // Sidebar Toggle
  $(".offcanvas-close,.offcanvas-overlay").on("click", function () {
    $(".offcanvas-area").removeClass("info-open");
    $(".offcanvas-overlay").removeClass("overlay-open");
  });
  $(".sidebar-toggle").on("click", function () {
    $(".offcanvas-area").addClass("info-open");
    $(".offcanvas-overlay").addClass("overlay-open");
  });

  //Body overlay Js
  $(".body-overlay").on("click", function () {
    $(".offcanvas-area").removeClass("opened");
    $(".body-overlay").removeClass("opened");
  });

  // Header sticky
  $(window).scroll(function () {
    if ($(this).scrollTop() > 250) {
      $("#header-sticky").addClass("active-sticky");
    } else {
      $("#header-sticky").removeClass("active-sticky");
    }
  });

  // Nice Select
  $('.single-input select').niceSelect();
  $('.coinefy-input-filter select').niceSelect();

  // Data Css js
  $("[data-background").each(function () {
    $(this).css(
      "background-image",
      "url( " + $(this).attr("data-background") + "  )"
    );
  });

  $("[data-width]").each(function () {
    $(this).css("width", $(this).attr("data-width"));
  });

  $("[data-bg-color]").each(function () {
    $(this).css("background-color", $(this).attr("data-bg-color"));
  });

  // Backtotop js  
  if ($(".back-to-top-wrap path").length > 0) {
    var progressPath = document.querySelector(".back-to-top-wrap path");
    var pathLength = progressPath.getTotalLength();
    progressPath.style.transition = progressPath.style.WebkitTransition =
      "none";
    progressPath.style.strokeDasharray = pathLength + " " + pathLength;
    progressPath.style.strokeDashoffset = pathLength;
    progressPath.getBoundingClientRect();
    progressPath.style.transition = progressPath.style.WebkitTransition =
      "stroke-dashoffset 10ms linear";
    var updateProgress = function () {
      var scroll = $(window).scrollTop();
      var height = $(document).height() - $(window).height();
      var progress = pathLength - (scroll * pathLength) / height;
      progressPath.style.strokeDashoffset = progress;
    };
    updateProgress();
    $(window).scroll(updateProgress);
    var offset = 150;
    var duration = 550;
    jQuery(window).on("scroll", function () {
      if (jQuery(this).scrollTop() > offset) {
        jQuery(".back-to-top-wrap").addClass("active-progress");
      } else {
        jQuery(".back-to-top-wrap").removeClass("active-progress");
      }
    });
    jQuery(".back-to-top-wrap").on("click", function (event) {
      event.preventDefault();
      jQuery("html, body").animate({
        scrollTop: 0
      }, duration);
      return false;
    });
  }
  // Odometer active
  var odo = $('.odometer');
  odo.each(function () {
    $('.odometer').appear(function (e) {
      var countNumber = $(this).attr('data-count');
      $(this).html(countNumber);
    });
  });

  // Datepicker active
  if ($('#d_today').length) {
    (function () {
      const d_today = new Datepicker(document.querySelector('#d_today'), {
        buttonClass: 'btn',
        todayHighlight: true
      });
    })()
  }

  // Image Preview
  $(document).on('change', 'input[type="file"]', function (event) {
    var $file = $(this),
      $label = $file.next('label'),
      $labelText = $label.find('span'),
      labelDefault = $labelText.text();

    var fileName = $file.val().split('\\').pop(),
      tmppath = URL.createObjectURL(event.target.files[0]);

    // Check successfully selection
    if (fileName) {
      $label.addClass('file-ok').css('background-image', 'url(' + tmppath + ')');
      $labelText.text(fileName);
    } else {
      $label.removeClass('file-ok');
      $labelText.text(labelDefault);
    }
  });

  // Blog active item
  $(document).on('mouseover', '.blog-five-item-item', function () {
    $('.blog-five-item-item').removeClass('active');
    $(this).addClass('active');
  });


  // Price active item
  $(document).on('mouseover', '.investment-item', function () {
    $('.investment-item').removeClass('plan-active');
    $(this).addClass('plan-active');
  });


    // Notifications dropdown
    document.addEventListener('DOMContentLoaded', () => {
        const notificationsDropBtn = document.querySelector('.notifications-drop-btn');
        const dropdownMenu = document.querySelector('.dropdown-menu');
        const langToggle = document.getElementById('header-lang-toggle');
        const langList = document.getElementById('language-list');
        const langOptions = langList ? langList.querySelectorAll('a') : [];

        if (notificationsDropBtn && dropdownMenu) {
            // Toggle dropdown visibility on button click
            notificationsDropBtn.addEventListener('click', function (event) {
                event.stopPropagation();
                dropdownMenu.classList.toggle('show');
            });

            // Hide notifications dropdown if clicked outside of it
            document.addEventListener('click', function (event) {
                if (!dropdownMenu.contains(event.target) && !notificationsDropBtn.contains(event.target)) {
                    dropdownMenu.classList.remove('show');
                }
            });
        }

        if (langToggle && langList) {
            langToggle.addEventListener('click', (event) => {
                event.stopPropagation();
                langList.classList.toggle('lang-list-open');
            });

            // Hide language dropdown if clicked outside of it
            document.addEventListener('click', (event) => {
                if (!langToggle.contains(event.target) && !langList.contains(event.target)) {
                    langList.classList.remove('lang-list-open');
                }
            });
        }

        // Hide any dropdown if clicked outside of it
        document.addEventListener('click', function (event) {
            if (dropdownMenu && !dropdownMenu.contains(event.target) && !notificationsDropBtn.contains(event.target)) {
                dropdownMenu.classList.remove('show');
            }

            if (langToggle && langList && !langToggle.contains(event.target) && !langList.contains(event.target)) {
                langList.classList.remove('lang-list-open');
            }
        });
    });



})(jQuery);
